#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/stat.h>

#define PAGESIZE 4096

/* 
 * Notes:
 * 	- This doesn't take into account if the loaded code spreads over 
 * 	  multiple pages.
 * 	- This was written while sick and on some medicene that makes me 
 * 	  feel drowsy. However, it should still work. That said, I don't 
 * 	  like feeling sick :< 
 * 	- There isn't any actual network communications, its only to prove
 * 	  a point.
 */

void removed()
{
	printf("I was removed from the on-disk image ;)\n");
}

void load_pieces()
{
	FILE *f;
	char buf[64];
	char fname[32];
	unsigned int where;
	int fd;
	struct stat statbuf;
	unsigned char *what;
	
	printf("Loading pieces of code into memory\n");

	f = fopen("pieces.info", "r");
	if(f == NULL) {
		printf("Unable to load pieces.info, returning\n");
		return;
	}

	while(fgets(buf, 63, f)) {
		memset(fname, 0, sizeof(fname));
		//printf("%s\n", buf);
		sscanf(buf, "0x%08x %32s", &where, fname);
		printf("%p %s\n", where, fname);


		mprotect((void *)(where & ~(PAGESIZE-1)), PAGESIZE, PROT_READ|PROT_WRITE|PROT_EXEC);
		
		fd = open(fname, O_RDONLY);
		if(fd == -1) {
			printf("Unable to open %s: %s\n", fname, strerror(errno));
			exit(EXIT_FAILURE);
		}

		if(fstat(fd, &statbuf) == -1) {
			printf("Unable to fstat %s: %s\n", fname, strerror(errno));
			exit(EXIT_FAILURE);
		}

		if(read(fd, (void *)(where), statbuf.st_size) != statbuf.st_size) {
			printf("Unable to write code to location\n");
			exit(EXIT_FAILURE);
		}

		close(fd);
		mprotect((void *)(where & ~(PAGESIZE-1)), PAGESIZE, PROT_READ|PROT_EXEC);
	}

	fclose(f);
}

int main(int argc, char **argv)
{
	load_pieces();
	removed();
}
