#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <elf.h>

#include <signal.h>
//#include <sys/ucontext.h>

#include "int3_loader.h"

Elf32_Ehdr elf_header;
Elf32_Phdr *prog_headers;

#define PAGESIZE 4096

unsigned long stack;

//#define USE_GNU
//#define __USE_GNU

// #define printf(...)

#ifndef REG_EIP
enum
{
	REG_GS = 0,
# define REG_GS         REG_GS
	REG_FS,
# define REG_FS         REG_FS
	REG_ES,
# define REG_ES         REG_ES
	REG_DS,
# define REG_DS         REG_DS
	REG_EDI,
# define REG_EDI        REG_EDI
	REG_ESI,
# define REG_ESI        REG_ESI
	REG_EBP,
# define REG_EBP        REG_EBP
	REG_ESP,
# define REG_ESP        REG_ESP
	REG_EBX,
# define REG_EBX        REG_EBX
	REG_EDX,
# define REG_EDX        REG_EDX
	REG_ECX,
# define REG_ECX        REG_ECX
	REG_EAX,
# define REG_EAX        REG_EAX
	REG_TRAPNO,
# define REG_TRAPNO     REG_TRAPNO
	REG_ERR,
# define REG_ERR        REG_ERR
	REG_EIP,
# define REG_EIP        REG_EIP
	REG_CS,
# define REG_CS         REG_CS
	REG_EFL,
# define REG_EFL        REG_EFL
	REG_UESP,
# define REG_UESP       REG_UESP
	REG_SS
# define REG_SS REG_SS
};
#endif

#define STACK_SIZE (4096 * 4) // 16k should be plenty I suspect
#define AUXV_NUM 6

void create_stack(int argc, char **argv)
{
        int arg_size, arg_len, i;
        unsigned char *p, *envp;
        unsigned char **ptr;
        unsigned char **addys;
        Elf32_auxv_t aux;

        arg_size = arg_len = 0;

        printf("Calcuating stack information\n");

        p = mmap(0x20000000, STACK_SIZE, PROT_READ|PROT_WRITE, MAP_PRIVATE|MAP_ANONYMOUS|MAP_GROWSDOWN|MAP_FIXED, -1, 0);
        if(p == NULL) {
                printf("Unable to map stack area... %m\n");
                exit(EXIT_FAILURE);
        }

        p += STACK_SIZE;
        p -= 4;

        printf("\tStack address is %p\n", p);

        for(i = 0; i < argc; i++) {
                arg_len += strlen(argv[i]) + 1;
        }
        printf("\tNeed %d bytes to store the argv strings\n", arg_len);

        arg_size = 4; // argc
        arg_size += argc * sizeof(char *); // argv array
        arg_size += 4; // terminating NULL
        arg_size += 4; // terminating NULL
        arg_size += AUXV_NUM * sizeof(Elf32_auxv_t);
        arg_size += 4; // add a null for good luck :<

        printf("\tNeed %d bytes to store argc, argv, envp, auxv info\n", arg_size);
        printf("\tThis leaves %d bytes left for the program for the running program\n", STACK_SIZE-(arg_len + arg_size + 4));

        ptr = p - arg_size - arg_len;
        stack = (unsigned long) ptr;
        *ptr++ = argc;
        p -= arg_len;
        for(i = 0; i < argc; i++) {
                strcat(p, argv[i]);
                *ptr++ = p;
                p += strlen(argv[i]) + 1;
        }
        ptr++; // terminating NULL
        ptr++; // terminate envp

        /*
         * The 0x20 entry is used to control where we jump to if we have SYSENTER support.. this was a big stumbling block
         * for me.
         *
         * Pointer to the global system page used for system calls and other nice things.
         * #define AT_SYSINFO      32
         * #define AT_SYSINFO_EHDR 33
         */

        // now for auxv
        *ptr++ = 0x20;
        *ptr++ = 0xffffe400;
        *ptr++ = AT_ENTRY;
        *ptr++ = elf_header.e_entry;
        *ptr++ = AT_FLAGS;
        *ptr++ = 0;
        *ptr++ = AT_PHDR;
        *ptr++ = 0x08048000 + elf_header.e_phoff;
        *ptr++ = AT_PHNUM;
        *ptr++ = elf_header.e_phnum;
        *ptr++ = AT_NULL;
        *ptr++ = 0;

}

void load_elf(int fd)
{	
	unsigned long min, offset, i, prot;

	
	if(read(fd, &elf_header, sizeof(Elf32_Ehdr)) != sizeof(Elf32_Ehdr)) {
		fprintf(stderr, "\t[-] Unable to read %d bytes from file, %s, most likely not an ELF file\n", sizeof(Elf32_Ehdr), strerror(errno));
		exit(EXIT_FAILURE);
	}

	if(memcmp(elf_header.e_ident, ELFMAG, SELFMAG) != 0) {
		fprintf(stderr, "\t[-] File doesn't appear to be an ELF binary, bailing\n");
		exit(EXIT_FAILURE);
	}

	if(elf_header.e_machine != EM_386 || elf_header.e_type != ET_EXEC || elf_header.e_version != EV_CURRENT ||
		elf_header.e_ehsize != sizeof(Elf32_Ehdr) || elf_header.e_phentsize != sizeof(Elf32_Phdr) || 
		elf_header.e_phnum > 8) {
		fprintf(stderr, "\t[-] Binary layout isn't what we expected, bailing\n");
		exit(EXIT_FAILURE);
	}
	
	prog_headers = malloc(elf_header.e_phnum * sizeof(Elf32_Phdr));
	if(prog_headers == NULL) {
		fprintf(stderr, "\t[-] Unable to malloc memory needed for program headers, bailing\n");
		exit(EXIT_FAILURE);
	}

	if(lseek(fd, elf_header.e_phoff, SEEK_SET) != elf_header.e_phoff) {
		fprintf(stderr, "\t[-] Unable to lseek to offset, %s\n", strerror(errno));
		exit(EXIT_FAILURE);
	}

	if(read(fd, prog_headers, elf_header.e_phnum * sizeof(Elf32_Phdr)) != elf_header.e_phnum * sizeof(Elf32_Phdr)) {
		fprintf(stderr, "\t[-] Unable to read in program headers: %s\n\t[-] bailing\n", strerror(errno));
		exit(EXIT_FAILURE);
	}
	fprintf(stderr, "\t[*] %d program headers\n", elf_header.e_phnum);
	
	
	fprintf(stderr, "[*] Scanning through program headers\n");

	min = prog_headers[0].p_vaddr;
	offset = 0;
	
	for(i = 0; i < elf_header.e_phnum; i++) {
		fprintf(stderr, "\t[*] Entry %d: %sload entry\n", i, prog_headers[i].p_type == PT_LOAD?"":"non-");
		if(prog_headers[i].p_type != PT_LOAD) continue;
		
		prot = 0;
		if(prog_headers[i].p_flags & PF_R) prot |= PROT_READ;
		if(prog_headers[i].p_flags & PF_W) prot |= PROT_WRITE;
		if(prog_headers[i].p_flags & PF_X) prot |= PROT_EXEC;

		if(mmap(min, prog_headers[i].p_filesz, prot, MAP_PRIVATE|MAP_FIXED, fd, 0) != min) {
			printf("Unable to map program @ %p\n", min);
			exit(EXIT_FAILURE);
		}
	
		
		min += prog_headers[i].p_filesz;
		min += PAGESIZE;
		min &= ~(PAGESIZE - 1);

		offset += prog_headers[i].p_filesz;
	}
	
}

#include </usr/include/sys/ucontext.h>
#include "libdis.h"

/* From asm/processor.h */
#define X86_EFLAGS_CF   0x00000001 /* Carry Flag */
#define X86_EFLAGS_PF   0x00000004 /* Parity Flag */
#define X86_EFLAGS_AF   0x00000010 /* Auxillary carry Flag */
#define X86_EFLAGS_ZF   0x00000040 /* Zero Flag */
#define X86_EFLAGS_SF   0x00000080 /* Sign Flag */
#define X86_EFLAGS_TF   0x00000100 /* Trap Flag */
#define X86_EFLAGS_IF   0x00000200 /* Interrupt Flag */
#define X86_EFLAGS_DF   0x00000400 /* Direction Flag */
#define X86_EFLAGS_OF   0x00000800 /* Overflow Flag */
/* </asm/processor.h> */

void sigtrap_handler(int signo, siginfo_t *info, ucontext_t *context)
{
	unsigned int *x;
	int i;
	int success;
	int done;
	int cased;
	unsigned int efl, eip;
	printf("Inside sigtrap_handler\n");

/*	x = &x;
	
	for(i = 0; i < 40; i++) {
		printf("x[%d]: %p\n", i, x[i]);
	}
	fflush(stdout); */

	printf("--> si_signo: %d\n", info->si_signo);
	printf("--> si_errno: %d\n", info->si_errno);
	printf("--> si_code: %d\n", info->si_code);
	printf("--> faulting address: %p\n", info->si_addr);
	
	success = -1;
	
	efl = context->uc_mcontext.gregs[REG_EFL];
	
	for(i = 0; i <sizeof(jumpme) / sizeof(struct entries); i++) {
		if(jumpme[i].src == info->si_addr) {
			printf("--> Found entry\n");
			done = jumpme[i].flags;
			cased = 0;	
			printf("--> EFLAGS: %c%c%c%c%c%c%c%c%c\n", 
				efl&X86_EFLAGS_OF?'O':'o', efl&X86_EFLAGS_DF?'D':'d', efl&X86_EFLAGS_IF?'I':'i',
				efl&X86_EFLAGS_TF?'T':'t', efl&X86_EFLAGS_SF?'S':'s', efl&X86_EFLAGS_ZF?'Z':'z',
				efl&X86_EFLAGS_AF?'A':'a', efl&X86_EFLAGS_PF?'P':'p', efl&X86_EFLAGS_CF?'C':'c');
				
			if(jumpme[i].type == insn_jcc || jumpme[i].type == insn_callcc) {
				cased = 1;
				printf("   --> Got a conditional eip moving thingy :)\n");
				if(jumpme[i].flags & insn_zero_clear) {
					printf("   --> Is the zero flag cleared?\n");
					if((efl & X86_EFLAGS_ZF) == 0) {
						printf("   --> Yep, coolio.\n");
						success = 1;
					} else {
						printf("   --> Nope\n");
						//success = 0;
					}
					done &= ~insn_zero_clear;
				}
		
				if(jumpme[i].flags & insn_zero_set) {
					printf("   --> Is the zero flag set?\n");
					if((efl & X86_EFLAGS_ZF) == X86_EFLAGS_ZF) {
						printf("   --> Yep, cool.\n");
						if(success == -1) success = 1; 
					} else {
						printf("   --> Nope :<\n");
						success = 0;
						//if(success != 1)success = 0;
					}
					done &= ~insn_zero_set;
				}	
			
				if(jumpme[i].flags & insn_carry_clear) {
					printf("   --> Is the carry flag cleared?\n");
					if((efl & X86_EFLAGS_CF) == 0) {
						printf("--> Yep.\n");
						if(success == -1) success = 1;
					} else {
						printf("   --> Nope :<\n");
						success = 0;
					}
					done &= ~insn_carry_clear;
				}

				if(jumpme[i].flags & insn_carry_set) {
					printf("   --> Is the carry flag set?\n");
					if((efl & X86_EFLAGS_CF) == X86_EFLAGS_CF) {
						printf("   --> Yep, carrying on\n");
						if(success == -1) success = 1;
					} else {
						success = 0;
						printf("   --> Nope\n");
					}

					done &= ~insn_carry_set;
				}
				
				if(done != 0) {
					printf("   --> !!! We haved handled all expected conditionals.. %04x left\n", done);
				}
				
			} 
			
			if(jumpme[i].type == insn_call) {
				unsigned long *stack;
				
				cased = 1;
				success = 1;
				printf("   --> CALL instruction\n");
				context->uc_mcontext.gregs[REG_ESP] -= 4;
				stack = context->uc_mcontext.gregs[REG_ESP];
				stack[0] = context->uc_mcontext.gregs[REG_EIP] += jumpme[i].len;
			}
			
			if(jumpme[i].type == insn_jmp) {
				printf("   --> jump instruction\n");
				success = cased = 1;
			}
			
			if(cased == 0) {
				printf("--> Not sure what we have, but we have an entry.\n");
			}
			if(success == -1) success = 0;

			if(success == 1) {
				printf("   --> OK, conditionals was met, jumping to destination of 0x%08x\n", 
					jumpme[i].dst);
				context->uc_mcontext.gregs[REG_EIP] = jumpme[i].dst;
			} else {
				printf("   --> Conditionals wasn't met, moving EIP to next instruction\n");
				context->uc_mcontext.gregs[REG_EIP] += jumpme[i].len;
			}
			
			break;
		}
	}

	if(i == sizeof(jumpme) / sizeof(struct entries)) {
		printf("--> Couldn't find the faulting address.\n");
	}
	
	//info->si_addr = 0xfeedface;
	//context->uc_mcontext.gregs[REG_EIP]  = 0xdeadbeef; 
	
}					

void signals()
{
        struct sigaction sa;

        memset(&sa, 0, sizeof(struct sigaction));
        sa.sa_sigaction = sigtrap_handler;
        sa.sa_flags = SA_SIGINFO;

        if(sigaction(SIGTRAP, &sa, NULL) == -1) {
                printf("Curious, unable to load sigsegv handler\n");
                exit(-1);
	}
}

int main(int argc, char **argv)
{
	int fd;
	int (*func)(int, char **, char **);

	setvbuf(stdout, NULL, _IONBF, 0);
	
	fd = open("test", O_RDONLY);
	load_elf(fd);
	signals();
        create_stack(argc, argv);


        func = elf_header.e_entry;
        printf("Preparing to jump into cyberspace... hold on.\n");

        __asm__("movl %0, %%ebp; movl %0, %%esp; jmp *%1" :: "r"(stack), "r"(func));


}


