#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <elf.h>
#include <fcntl.h>

#define PAGESIZE 4096

/* part of SELF */

Elf32_Ehdr elf_header;
Elf32_Phdr *prog_headers;
Elf32_Shdr *sect_headers;
Elf32_Sym  *symbol_table;

unsigned int load_base;
int first_load;

int elf_len;

int symbols_present;

unsigned char *strtable;
int symbol_idx, string_idx, symbol_cnt;

int load_elf(char *file)
{
	int fd, len, i, prot, slop, base;
	struct stat statbuf;
	
	printf("\t[+] Elf loader opening %s\n", file);	
	
	if((fd = open(file, O_RDONLY)) == -1) {
		printf("\t\t[-] Failed to open %s: %s\n", file, strerror(errno));
		return -1;
	}

	if(fstat(fd, &statbuf)==-1) {
		printf("\t\t[-] Unable to fstat(): %s\n", strerror(errno));
		exit(EXIT_FAILURE);
	}

	elf_len = statbuf.st_size;
	
	if(read(fd, &elf_header, sizeof(Elf32_Ehdr)) != sizeof(Elf32_Ehdr)) {
		printf("\t\t[-] Unable to read elf header into memory\n");
		return -1;
	}

	if(memcmp(elf_header.e_ident, ELFMAG, SELFMAG) != 0) {
		printf("\t\t[-] File doesn't appear to be ELF\n");
		exit(EXIT_FAILURE);
	}

	if(elf_header.e_machine != EM_386) {
		printf("\t\t[-] Binary isn't x86. This may/will require some work to implement this correctly then..\n");
		printf("\t\t[-] hrm :<\n");
		exit(EXIT_FAILURE);
	}

	if(elf_header.e_type != ET_EXEC) {
		printf("\t\t[-] Currently this loader only supports ET_EXEC. This will change though.\n");
		return -1;
	}

	if(elf_header.e_version != EV_CURRENT) {
		printf("\t\t[-] This doesn't appear to be a \"current\" ELF file.\n");
		return -1;
	}

	if(elf_header.e_ehsize != sizeof(Elf32_Ehdr) || elf_header.e_phentsize != sizeof(Elf32_Phdr) || 
		elf_header.e_phnum > 20) {
		printf("\t\t[-] Invalid ELF header sizes\n");
		return -1;
	}

	// Okay, thats about as much sanity checking I can stomach at the moment.
	
	if(lseek(fd, elf_header.e_phoff, SEEK_SET) != elf_header.e_phoff) {
		printf("\t\t[-] Unable to lseek() to program headers offset: %s\n", strerror(errno));
		return -1;
	}

	printf("\t\t[+] %d program headers\n", elf_header.e_phnum);
	
	len = sizeof(Elf32_Phdr) * elf_header.e_phnum;
	
	prog_headers = malloc(len);
	
	if(read(fd, prog_headers, len) != len) {
		printf("\t\t[-] Unable to read program headers into memory\n");
		return -1;
	}

#if 0
	if(options.analyser.symordisasm == 1) {
		
		printf("\t[+] Reading symbols into memory\n");
		if(elf_header.e_shentsize == 0 || elf_header.e_shoff == 0 || elf_header.e_shnum == 0) {
			printf("\t\t[-] It appears there is no symbol table. Perhaps recompile and leave symbols in this time?\n");
			return -1;
		}

		symbols_present = 1;
		
		if(lseek(fd, elf_header.e_shoff, SEEK_SET) != elf_header.e_shoff) {
			printf("\t\t[-] Unable to lseek() to end of section headers: %s\n", strerror(errno));
			return -1;
		}

		sect_headers = malloc(elf_header.e_shnum * elf_header.e_shentsize);

		if(read(fd, sect_headers, elf_header.e_shnum * elf_header.e_shentsize) != elf_header.e_shnum * elf_header.e_shentsize) {
			printf("\t\t[-] Unable to read in file\n");
			return -1;
		}

		symbol_idx = string_idx = -1;
		
		for(i = 0; i < elf_header.e_shnum; i++) {
			if(sect_headers[i].sh_type == SHT_SYMTAB) symbol_idx = i;
			if(sect_headers[i].sh_type == SHT_STRTAB) string_idx = i;
		}

		if(symbol_idx == -1 || string_idx == -1) {
			printf("\t\t[-] Unable to find %s\n", symbol_idx==-1?"symbol table":"string table");
			return -1;
		}
		
		strtable = malloc(sect_headers[string_idx].sh_size + 1);
		memset(strtable, 0, sect_headers[string_idx].sh_size + 1);
		if(lseek(fd, sect_headers[string_idx].sh_offset, SEEK_SET) != sect_headers[string_idx].sh_offset) {
			printf("\t\t[-] Unable to seek to string table start.\n");
			return -1;
		}
		
		if(read(fd, strtable, sect_headers[string_idx].sh_size) != sect_headers[string_idx].sh_size) {
			printf("\t\t[-] Unable to read string table in\n");
			return -1;
		}

		symbol_table = malloc(sect_headers[symbol_idx].sh_size + 1);
		memset(symbol_table, 0, sect_headers[symbol_idx].sh_size + 1);
		
		if(lseek(fd, sect_headers[symbol_idx].sh_offset, SEEK_SET) != sect_headers[symbol_idx].sh_offset) {
			printf("\t\t[-] Unable to lseek to symbol table start\n");
			return -1;
		}

		if(read(fd, symbol_table, sect_headers[symbol_idx].sh_size) != sect_headers[symbol_idx].sh_size) {
			printf("\t\t[-] Unable to read symbol table in\n");
			return -1;
		}

		symbol_cnt = sect_headers[symbol_idx].sh_size / sizeof(Elf32_Sym);
	}
#endif 
	
	first_load = -1;
	
	for(i = 0; i < elf_header.e_phnum; i++) {
		printf("\t\t[+] Program header %d is of type %d:%x\n", i, prog_headers[i].p_type, prog_headers[i].p_type);

		if(prog_headers[i].p_type != PT_LOAD) {
			printf("\t\t\t[-] Skipping non-load segment\n");
			continue;
		}
		if(first_load == -1) first_load = i;

		prot = 0;

		//if(prog_headers[i].p_flags & PF_R) prot |= PROT_READ;
		//if(prog_headers[i].p_flags & PF_W) prot |= PROT_WRITE;
		//if(prog_headers[i].p_flags & PF_X) prot |= PROT_EXEC;

		prot = PROT_READ|PROT_WRITE;
		
		slop = prog_headers[i].p_vaddr & (PAGESIZE - 1);
		base = prog_headers[i].p_vaddr & ~(PAGESIZE - 1); // (same as subtracting slop)
		
		if(mmap((void *)(base), prog_headers[i].p_filesz + slop, prot, MAP_FIXED|MAP_PRIVATE, fd, prog_headers[i].p_offset - 
			slop) != (void *)(base)) {
			printf("\t\t\t[-] :< Unable to mmap() program header in.\n");
			return -1;
		}
		
	}
	
	load_base = prog_headers[first_load].p_vaddr & ~(PAGESIZE -1);
		
	return 0;
}

int loader_isvalid(unsigned int addy)
{
	int i;
	if(addy == 0) return 0;

	for(i = 0; i < elf_header.e_phnum; i++) {
		if(addy >= (prog_headers[i].p_vaddr & ~(PAGESIZE-1)) && addy <= ((prog_headers[i].p_vaddr + prog_headers[i].p_filesz + PAGESIZE) & ~(PAGESIZE - 1))) return 1;
	}
	return 0;
}
