#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <elf.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>

Elf32_Ehdr *ehdr;
Elf32_Phdr *phdr;

unsigned int load_address, entry_point, file_offset, section_len;

unsigned char *file_data;
unsigned int file_size, fd, pagesize, encryption_len;

int load_section, note_section;
int dump_count;

int padding;

unsigned int stub_file_offset;

#include "decrypt.h"

#define DECRYPT_XOR_START 2
#define DECRYPT_LEN_START 7
#define DECRYPT_ENTRY_POINT 44

/* This reads the file in, pads it to a page boundary, and then writes the decryption loop in */

void load_file(char *fname)
{
	struct stat statbuf;
	unsigned char pad[4096];
	
	fd = open(fname, O_RDWR);
	if(fd == -1) {
		perror(fname);
		exit(EXIT_FAILURE);
	}

	if(fstat(fd, &statbuf) == -1) {
		perror("fstat");
		exit(EXIT_FAILURE);
	}
	
	lseek(fd, 0, SEEK_END);
	padding = 4096 - (statbuf.st_size & 4095);
	printf("Writing %d bytes\n", padding);
	memset(pad, 0, sizeof(pad));
	write(fd, pad, padding);
	write(fd, decrypt, decrypt_len);
	
	file_size = statbuf.st_size;
	file_data = mmap(NULL, file_size + padding + decrypt_len, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if(file_data == MAP_FAILED) {
		perror("mmap");
		exit(EXIT_FAILURE);
	}

	
}

/* Yes, I know, absolutely no sanity checking, but it doesn't matter.
 * This gets the data out of the elf header that we need */

void parse_headers()
{
	int i, slop;
	unsigned char *p;

	ehdr = (Elf32_Ehdr *)file_data;

	entry_point = ehdr->e_entry;	/* The entry point is, more often that not, the start of the executable code in a binary */
	
	p = file_data + ehdr->e_phoff;
	phdr = (Elf32_Phdr *)p;

	for(i = 0; i < ehdr->e_phnum; i++) {
		if(phdr[i].p_type == PT_LOAD) {
			if(phdr[i].p_flags & PF_W) continue;
			slop = phdr[i].p_vaddr & (pagesize - 1);
			load_address = phdr[i].p_vaddr - slop;
			
			file_offset = phdr[i].p_offset;
			load_section = i;
			section_len = phdr[i].p_filesz;		
		}

		if(phdr[i].p_type == PT_NOTE) {
			note_section = i;
		}
	}
}

void encrypt_text()
{
	unsigned char key[] = "\xca\xfe\xba\xbe\xb0\x0b\x1e\x50";
	unsigned char *p;
	int i;

	encryption_len = entry_point - load_address;
	p = file_data + file_offset + (entry_point - load_address);
	
	printf("file_data: %p\n", file_data);
	printf("file_offset: %d\n", file_offset);
	printf("entry_point (%p) - load_address (%p): %d\n", entry_point, load_address,  entry_point - load_address);

	printf("p: 0x%08x\n", p);
	
	for(i = 0; i < encryption_len; i++) {
		p[i] ^= key[i%8];
	}
	
}

void dump_mem()
{
	char buf[100];
	int fd;
	
	sprintf(buf, "dump.%d", dump_count++);
	fd = open(buf, O_WRONLY|O_CREAT|O_TRUNC, 0700);
	if(fd == -1) {
		perror("open");
		exit(EXIT_FAILURE);
	}
	write(fd, file_data, file_size);
	
	close(fd);
}

void fixup_decrypt()
{
	int i;
	unsigned char *p;

	p = file_data + file_size + padding;
	printf("%08x\n", (unsigned long)*p);
	printf("0x%08x\n", p);
	
	for(i = 0; i < 32; i+=8) {
		//printf("%d\n", (i/8));
		p[DECRYPT_XOR_START + (i/8)] = (entry_point >> i) & 0xff;
	}

	for(i = 0; i < 32; i+=8) {
		p[DECRYPT_LEN_START + (i/8)] = (encryption_len >> i) & 0xff;
	}

	for(i = 0; i < 32; i+=8) {
		p[DECRYPT_ENTRY_POINT + (i/8)] = (entry_point >> i) & 0xff;
	}
	//memcpy(file_data + file_size + padding, decrypt, decrypt_len);
}

void patch_headers()
{
	ehdr->e_entry = 0x50000000;

	phdr[load_section].p_flags |= PF_W;
	
	phdr[note_section].p_type = PT_LOAD;
	phdr[note_section].p_flags = PF_R|PF_X;
	phdr[note_section].p_offset = file_size+padding;
	phdr[note_section].p_vaddr = 0x50000000;
	phdr[note_section].p_paddr = phdr[note_section].p_vaddr;
	phdr[note_section].p_filesz = decrypt_len;
	phdr[note_section].p_memsz = decrypt_len;
	phdr[note_section].p_align = phdr[load_section].p_align;
	
	
}

int main(int argc, char **argv)
{
	if(argc == 1) {
		printf("%s binary_to_encrypt\n", argv[0]);
		exit(EXIT_FAILURE);
	}

	if(getuid() != geteuid()) {
		printf("Why are you running this suid?\n");
		exit(EXIT_FAILURE);
	}

	
	pagesize = getpagesize();
	
	load_file(argv[1]);
	parse_headers();	
	encrypt_text();
	patch_headers();	
	
	//dump_mem();
	
	fixup_decrypt();
	
	msync(file_data, file_size + padding + decrypt_len, MS_SYNC);
	munmap(file_data, file_size + padding + decrypt_len);
	close(fd);
	
}

\
