#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <elf.h>

int fd;

unsigned char *file_data;
struct stat statbuf;

Elf32_Ehdr *ehdr;
Elf32_Shdr *shdr;
Elf32_Phdr *phdr;
Elf32_Sym *sym;

int sym_num;
unsigned char *string_table;

unsigned long encrypt_func, decrypt_func, first, second, third, fourth, main_p;
int first_len, second_len, third_len, fourth_len, main_p_len;


void load_target()
{
	unsigned char *p;
	int i, j;
	
	fd = open("target", O_RDWR);
	if(fd == -1) exit(-1);

	if(fstat(fd, &statbuf) == -1) exit(-2);

	file_data = mmap(NULL, statbuf.st_size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);

	if(file_data == MAP_FAILED) {
		printf("Unable to mmap file\n");
		exit(EXIT_FAILURE);
	}

	if(memcmp(file_data, ELFMAG, SELFMAG) != 0) {
		printf("Not an elf file\n");
		exit(EXIT_FAILURE);
	}
	
	ehdr = (Elf32_Ehdr *)file_data;

	p = file_data + ehdr->e_shoff;

	shdr = (Elf32_Shdr *)p;

	for(i = ehdr->e_shnum-1; i != ehdr->e_shnum-3; i--) {
		if(shdr[i].sh_type == SHT_SYMTAB) {
			printf("Value is %d:%08x\n", shdr[i].sh_offset, shdr[i].sh_offset);
			p = file_data + shdr[i].sh_offset;
			sym = (Elf32_Sym *)p;
			sym_num = shdr[i].sh_size / sizeof(Elf32_Sym);
		}

		if(shdr[i].sh_type == SHT_STRTAB) {
			printf("Value is %d:%08x\n", shdr[i].sh_offset, shdr[i].sh_offset);
			string_table = file_data + shdr[i].sh_offset;
		}
	}
	
	p = file_data + ehdr->e_phoff;
	phdr = (Elf32_Phdr *)p;
}

void find_offsets()
{
	int i, good;

	for(i = 0; i < sym_num; i++) {
		if(ELF32_ST_TYPE(sym[i].st_info) != STT_FUNC) continue;
		
		good = 0;
		
		if(strcmp(string_table + sym[i].st_name, "first") == 0) {
			good = 1; 
			first = sym[i].st_value;
			first_len = sym[i].st_size;
		}
		
		if(strcmp(string_table + sym[i].st_name, "second") == 0) {
			good = 1; 
			second = sym[i].st_value;
			second_len = sym[i].st_size;
		}
		
		if(strcmp(string_table + sym[i].st_name, "third") == 0) {
			good = 1; 
			third = sym[i].st_value;
			third_len = sym[i].st_size;
		}
		
		if(strcmp(string_table + sym[i].st_name, "fourth") == 0) {
			good = 1; 
			fourth = sym[i].st_value;
			fourth_len = sym[i].st_size;
		}
		
		if(strcmp(string_table + sym[i].st_name, "main") == 0) {
			good=1; 
			main_p = sym[i].st_value;
			main_p_len = sym[i].st_size;
		}
		
		if(strcmp(string_table + sym[i].st_name, "encrypt_func") == 0) {
			good = 1; 
			encrypt_func = sym[i].st_value;
		}
		
		if(strcmp(string_table + sym[i].st_name, "decrypt") == 0) {
			good = 1; 
			decrypt_func = sym[i].st_value;
		}
		
		if(good) printf("%s @ 0x%08x, len %d\n", string_table + sym[i].st_name, sym[i].st_value, sym[i].st_size);
		
	}
	
}

void add_file_entry(FILE *f, unsigned long address, int offset, int len)
{
	fprintf(f, "\t{ 0x%08x, 0x%08x,0x%02x },\n", address, len, file_data[offset]);
}

void patch_jump(int offset, unsigned int what)
{

	file_data[offset] = 0xf1;
}

void encrypt_rest(unsigned int key, int offset, int len)
{
	int i;
	srandom(key);
	for(i = 1; i < len; i++) file_data[offset+i] ^= random() & 0xff;
}

void modify_binary()
{
	int offset, i;
	unsigned int jump_count;
	FILE *f;

	f = fopen("functions.h", "w+");
	setvbuf(f, NULL, _IONBF, 0);
	fprintf(f, "struct saved_bytes {\n\tunsigned long address;\n\tint len;\n\tunsigned char saved_byte;\n} saved_bytes[] = {\n");

	printf("first\n");
	offset = first - 0x08048000;
	add_file_entry(f, first+1, offset, first_len);
	patch_jump(offset, decrypt_func - (first+1));
	encrypt_rest((first+1), offset, first_len);
	
	printf("second\n");
	offset = second - 0x08048000;
	add_file_entry(f, second+1, offset, second_len);
	patch_jump(offset, decrypt_func - (second+1));
	encrypt_rest((second+1), offset, second_len);
	
	
	offset = third - 0x08048000;
	printf("third\n");
	add_file_entry(f, third+1, offset, third_len);
	patch_jump(offset, decrypt_func - (third+1));
	encrypt_rest((third+1), offset, third_len);

	offset = fourth - 0x08048000;
	printf("fourth\n");
	add_file_entry(f, fourth+1, offset, fourth_len);
	patch_jump(offset, decrypt_func - (fourth+1));
	encrypt_rest((fourth+1), offset, fourth_len);

/*
	printf("main\n");
	fflush(stdout);
	offset = main_p - 0x08048000;
	add_file_entry(f, main_p+5, offset, main_p_len);
	patch_jump(offset, decrypt_func - (main_p+5));
	encrypt_rest((main_p+5), offset, main_p_len);
*/	
	//file_data[offset+1+i] = 0xc3;	

	fseek(f, -2, SEEK_CUR);
	
	fprintf(f, "\n};\n");

	fclose(f);
}

void unload_target()
{
	msync(file_data, statbuf.st_size, MS_SYNC);
	munmap(file_data, statbuf.st_size);
	close(fd);
}

void fixup_phdr()
{
	int i;

	for(i = 0; i < ehdr->e_phnum; i++) 
		if(phdr[i].p_type == PT_LOAD)
				phdr[i].p_flags |= PF_W;
}

int main(int argc, char **argv)
{	
	load_target();
	find_offsets();
	modify_binary();

	fixup_phdr();
	
	unload_target();
}
