#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <signal.h>
#define __USE_GNU
#include <sys/ucontext.h>

#include "functions.h"


void fourth()
{
	printf("woah, fourth function called\n");
}

/* recursive function */
void third(int num)
{
	printf("third\n");
	if(num) third(num-1);
}

void second(int num)
{
	printf("second()\n");
	third(num);
}

void first(unsigned int what)
{
	printf("first(): %p\n", what);

	second(3);
	fourth();
}

void crypt_func(int signo, siginfo_t *info, ucontext_t *context);

int main(int argc, char **argv)
{
	struct sigaction sa;

	memset(&sa, 0, sizeof(struct sigaction));
	sa.sa_flags = SA_SIGINFO;
	sa.sa_sigaction = crypt_func;

	sigaction(SIGTRAP, &sa, NULL);
	sigaction(SIGSEGV, &sa, NULL);
	
	
	printf("My argc is %d\n", argc);
	first(0xcafebabe);
}

unsigned int call_func[20];
int call_num;


void crypt_func(int signo, siginfo_t *info, ucontext_t *context)
{
	unsigned char *p;
	int i, j;
	int *stack;
	
	switch(signo) {
		case SIGTRAP:
			printf("SIGTRAP @ %p\n", info->si_addr);
			context->uc_mcontext.gregs[REG_EIP]--;
			stack = (int *) context->uc_mcontext.gregs[REG_ESP];
			
			for(i = 0; i < 10; i++) printf("stack[%d]: %p\n", i, stack[i]);
			
			call_func[call_num++] = stack[0];
			printf("Saved EIP: %p\n", stack[0]);
			stack[0] = 0xdeadbeef;
	
			for(i = 0; i < sizeof(saved_bytes) / sizeof(struct saved_bytes); i++) {
				if(saved_bytes[i].address == info->si_addr) {
					printf("found\n");
			
					p = (unsigned char *)info->si_addr-1;
					p[0] = saved_bytes[i].saved_byte;
			
					srandom(info->si_addr);
			
					for(j=1; j < saved_bytes[i].len; j++) {
						p[j] ^= random() & 0xff;
					}
				}
			}
			break;
			
		case SIGSEGV:
			printf("segv @ %p\n", info->si_addr);
			--call_num;
			context->uc_mcontext.gregs[REG_EIP] = call_func[call_num];
			break;
	}
	
}


