#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <elf.h>
#include <signal.h>
#define __USE_GNU
#include <sys/ucontext.h>

int load_elf(char *name);


unsigned char *stack;
extern Elf32_Ehdr elf_header;

/* part of SELF */

#define STACK_SIZE (4096 * 4) // 16k should be plenty I suspect
#define AUXV_NUM 6



void create_stack(int argc, char **argv)
{
        int arg_size, arg_len, i;
        unsigned char *p, *envp;
        unsigned char **ptr;
        unsigned char **addys;
        Elf32_auxv_t aux;

        arg_size = arg_len = 0;


        printf("Calcuating stack information\n");

        p = mmap(0x20000000, STACK_SIZE, PROT_READ|PROT_WRITE, MAP_PRIVATE|MAP_ANONYMOUS|MAP_GROWSDOWN|MAP_FIXED, -1, 0);
        if(p == NULL) {
                printf("Unable to map stack area... %m\n");
                exit(EXIT_FAILURE);
        }

        p += STACK_SIZE;
        p -= 4;

        printf("\tStack address is %p\n", p);

        for(i = 0; i < argc; i++) {
                arg_len += strlen(argv[i]) + 1;
        }
        printf("\tNeed %d bytes to store the argv strings\n", arg_len);

        arg_size = 4; // argc
        arg_size += argc * sizeof(char *); // argv array
        arg_size += 4; // terminating NULL
        arg_size += 4; // terminating NULL
        arg_size += AUXV_NUM * sizeof(Elf32_auxv_t);
        arg_size += 4; // add a null for good luck :<

        printf("\tNeed %d bytes to store argc, argv, envp, auxv info\n", arg_size);
        printf("\tThis leaves %d bytes left for the program for the running program\n", STACK_SIZE-(arg_len + arg_size + 4));

        ptr = p - arg_size - arg_len;
        stack = (unsigned long) ptr;
        *ptr++ = argc;
        p -= arg_len;
        for(i = 0; i < argc; i++) {
                strcat(p, argv[i]);
                *ptr++ = p;
                p += strlen(argv[i]) + 1;
        }
        ptr++; // terminating NULL
        ptr++; // terminate envp

        /*
         * The 0x20 entry is used to control where we jump to if we have SYSENTER support.. this was a big stumbling block
         * for me.
         *
         * Pointer to the global system page used for system calls and other nice things.
         * #define AT_SYSINFO      32
         * #define AT_SYSINFO_EHDR 33
         */

        // now for auxv
        *ptr++ = 0x20;
        *ptr++ = 0xffffe400;
        *ptr++ = AT_ENTRY;
        *ptr++ = elf_header.e_entry;
        *ptr++ = AT_FLAGS;
        *ptr++ = 0;
        *ptr++ = AT_PHDR;
        *ptr++ = 0x08048000 + elf_header.e_phoff;
        *ptr++ = AT_PHNUM;
        *ptr++ = elf_header.e_phnum;
        *ptr++ = AT_NULL;
        *ptr++ = 0;

}

/* </SELF> */


struct  {
	unsigned long base_address;
	unsigned char key[8];
} segv_lookup[1000];

int segv_num = 0;

void sigsegv_handler(int signo, siginfo_t *siginfo, ucontext_t *context)
{
	int i, j;
	unsigned long addy;
	int done;
	unsigned char *p;
	
	printf("SIGSEGV handler\n");
	printf("siginfo: %p, ucontext: %p\n", siginfo, context);
	
	printf(" - Faulting address: %p\n", siginfo->si_addr);
	printf(" - si_errno: %d\n - si_code: %d\n", siginfo->si_errno, siginfo->si_code);
	printf(" - EIP of process: %p\n", context->uc_mcontext.gregs[REG_EIP]);

	addy = (unsigned long)(siginfo->si_addr) & ~4095;
	done = 0;
	
	for(i = 0; i < segv_num; i++) {
		if(segv_lookup[i].base_address == addy) {
			printf(" - Found segv_lookup entry, making page readable and decrypting\n");
			
			mprotect(addy, 4096, PROT_READ|PROT_WRITE);
			p = (unsigned char *)addy;
			
			for(j = 0; j < 4096; j++) {
				p[j] ^= segv_lookup[i].key[j%8];
			}
			
			printf(" - Done, continuing execution\n");
			
			done = 1;
			break;
		}
	}

	if(done == 0) {
		printf(" - Unable to find key :/, was looking for 0x%08x\n", addy);
	}
	
}

int main(int argc, char **argv)
{

	struct sigaction sigact;
	
	srandom(time(NULL));
	load_elf(argv[1]);		
	create_stack(argc, argv);

	memset(&sigact, 0, sizeof(struct sigaction));
	sigact.sa_sigaction = sigsegv_handler;
	sigact.sa_flags = SA_SIGINFO;
	
	sigaction(SIGSEGV, &sigact, NULL);
	
	printf("Jumping into program\n");
	__asm__("movl %0, %%ebp; movl %0, %%esp; jmp *%1" :: "r"(stack), "r"(elf_header.e_entry));
	
}


void segv_add_lookup(unsigned long address, unsigned char key[8])
{
	segv_lookup[segv_num].base_address = address;
	memcpy(segv_lookup[segv_num].key, key, 8);
	segv_num++;
}


