#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>

#define __USE_GNU
#include <sys/ucontext.h>

static int int3_count;

void int3(int signo, siginfo_t *info, ucontext_t *context)
{
	printf("eip: %p\n", context->uc_mcontext.gregs[REG_EIP]);
	fflush(stdout);
	if((int3_count++ % 25) == 0) sleep(1);
	context->uc_mcontext.gregs[REG_EFL] |= 0x100; // re-enable the trace
						      // flag.
}

int main()
{
	struct sigaction sa;
	
	printf("Running line example code\n");
	memset(&sa, 0, sizeof(struct sigaction));

	sa.sa_flags = SA_SIGINFO;
	sa.sa_sigaction = int3;
	sigaction(SIGTRAP, &sa, NULL);

	printf("switching to running line\n");

	write(1, "", 0); // We do not want to trace through .plt code, so we'll
			 // do that resolving here.
	
	__asm__("pushf;"
		"popl %eax;"
		"orl $0x100, %eax;" // 0x100 is the trace flag.
		"push %eax;"
		"popf;");

	write(1, "Going to exit after tracing through libc write;)\n", 50);
	//printf("tracing through libc\n");
	
	__asm__("xorl %eax, %eax;"
		"incl %eax;"
		"int $0x80;");
}
