#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/ptrace.h>
#include <sys/wait.h>
#include <linux/user.h>

int main(int argc, char **argv)
{
	pid_t pid;
	int status, first;
	struct user_regs_struct user;

	
	if(argc == 1) {
		printf("%s program_to_trace\n", argv[0]);
		exit(EXIT_FAILURE);
	}	

	if((pid = fork()) == 0) {
		ptrace(PTRACE_TRACEME, NULL, NULL, NULL);
		execlp(argv[1], argv[1], NULL);
		exit(-1);
	}
	

	status = 0;
	first = 1;
	while(waitpid(pid, &status, 0) > 0) {
		ptrace(PTRACE_GETREGS, pid, NULL, &user);
		fprintf(stderr, "EIP: %p\n", user.eip);
		ptrace(PTRACE_SINGLESTEP, pid, NULL, 0);
		first = 0;
	}
	
}
