#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

int timetrial_check()
{
	struct tm *tm;
	time_t what;
	what = time(NULL);
	tm = localtime(&what);

	if(tm->tm_year > 1983) return 0;
	if(tm->tm_mon > 8) return 0;
	if(tm->tm_mday > 19) return 0;
	
	return 1;
}

int is_valid_serial(char *string, int expected)
{
	int i;
	int result;

	result = 0;
	
	for(i = 0; i < strlen(string); i++) {
		if(string[i] < 'a' || string[i] > 'z') return 0;
		result += string[i];
		result *= string[i] * 7;
		result = ((result >> 16) & 0xffff) | ((result << 16) & 0xffff0000);
	}

	if(result != expected) return 0;

	return 1;
}
