#include <windows.h>
#include "sha1.h"
#include "rijndael.h"
#include "lip.h"

////////////////////////////////////////////////////////////////////////////////
// Skype credentials fun
// ProtectedStorage + SHA-1 + AES + CRC32 + "FastTrack Cipher" + RSA
//
// This program will look into the skype profiles available for the current
// Windows user and fully decrypt the credentials found
//
// Credentials structure
// - 16 bytes for MD5 sum of "login\nskyper\npasssword"
// - 128 bytes for user RSA private key (D) (1024 bits)
// - 4 bytes for skype RSA key ID
// - 192+ bytes for RSA block encrypted with skype RSA key
//   - padding
//   - skype encoded data
//     - user name
//     - 1 dword ?
//     - user RSA public key (N) (1024 bits)
//     - 1 dword ?
//   - SHA-1 hash of skype encoded data
//   - 1 byte = 0xbc
// - 2 bytes for CRC32 
//
// To decrypt the credentials under Windows :
// - recover the platform specific token in registry
// - decrypt it using CryptUnprotectData()
// - expand the material using some SHA-1 magic
// - set this as the AES key
// - read the credentials in the file
// - decrypt them using some AES magic
// - do a CRC32 of the first 16 bytes
// - use this to decrypt the remaining bytes using "FastTrack Cipher"
// - decrypt the RSA block using the good modulus
// - extract what you need from the information recovered :)
////////////////////////////////////////////////////////////////////////////////

#pragma comment(lib, "advapi32") // for registry functions
#pragma comment(lib, "crypt32") // for CryptUnprotectData()
#pragma comment(lib, "ws2_32") // for htonl() in lip.c

#define BYTESWAP(x) ((((x) & 0xff) << 24) \
	| (((x) >> 24) & 0xff) \
	| (((x) & 0x0000ff00) << 8) \
	| (((x) & 0x00ff0000) >> 8))

typedef struct {
	DWORD dwSize;
	BYTE *pbModulus;
} MODULUS;

static char szCredentials[1024];
static BYTE pbCredentials[512];
DWORD dwCredentialsSize;
static BYTE pbRSABlock[512];

static MODULUS mModulus[] = {
{ 192,
"\xC0\x95\xDE\x9E\x86\x8D\xC9\xFE\x1D\xE9\x4A\xB5\xE3\x8E\x8D\xBD\xCA\xE7\xE6"
"\x24\x9E\xF1\x47\xDE\x50\x3F\x3E\x1C\x76\xE6\x5A\xF0\x6F\x77\x14\x87\x2F\x35"
"\x27\xEE\x16\x41\x01\x70\x19\x6E\x4B\x22\x77\xDB\x20\x68\x27\x50\x5B\xC4\x8B"
"\x4B\x63\x15\x9F\x8E\xB0\xD5\x6D\x14\xDE\x68\x6E\x5F\x68\x40\xE3\x25\x22\xF8"
"\xB7\xDA\xFC\x6B\x90\x1B\x83\x49\x57\x57\xF4\x26\x9B\x59\x44\x0B\xC7\x82\x4D"
"\x45\x43\xEA\xE2\xB0\x0B\x9D\x4D\x21\xB0\xB0\x56\xAE\x53\xD6\xCC\x6C\x3A\x35"
"\xA5\xB1\x0E\x72\x71\x0C\xAD\x00\xDB\x5A\x42\x90\x3E\x27\x7E\x36\x1C\xD1\x76"
"\x1A\x07\x4A\xFE\x99\x7C\xC4\xA2\xC7\x74\x27\x85\x4E\xA1\x17\x6D\xA4\x81\xCA"
"\xDB\x98\x1E\xE1\x45\x71\x1C\x71\x60\xC5\xB3\x1F\x51\x94\xF6\x4E\xC9\x19\xBF"
"\x57\xDC\x54\x46\x56\xF3\x9B\xAD\x7B\xBD\xAC\xB6\xE4\x6F\x22\xC3\x01\x73\xDF"
"\x2E\xA7" },
{ 256,
"\xB8\x50\x6A\xEE\xD8\xED\x30\xFE\x1C\x0E\x67\x74\x87\x4B\x59\x20\x6A\x77\x32"
"\x90\x42\xA4\x9B\xE2\x40\x3D\xA4\x7D\x50\x05\x24\x41\x06\x7F\x87\xBC\xD5\x7E"
"\x65\x79\xB8\x3D\xF0\xBA\xDE\x2B\xEF\xF5\xB5\xCD\x8D\x87\xE8\xB3\xED\xAC\x5F"
"\x57\xFA\xBC\xCD\x49\x69\x59\x74\xE2\xB5\xE5\xF0\x28\x7D\x6C\x19\xEC\xC3\x1B"
"\x45\x04\xA9\xF8\xBE\x25\xDA\x78\xFA\x4E\xF3\x45\xF9\x1D\x33\x9B\x73\xCC\x2D"
"\x70\xB3\x90\x4E\x11\xCA\x57\x0C\xE9\xB5\xDC\x4B\x08\xB3\xC4\x4B\x74\xDC\x46"
"\x35\x87\xEA\x63\x7E\xF4\x45\x6E\x61\x46\x2B\x72\x04\x2F\xC2\xF4\xAD\x55\x10"
"\xA9\x85\x0C\x06\xDC\x9A\x73\x74\x41\x2F\xCA\xDD\xA9\x55\xBD\x98\x00\xF9\x75"
"\x4C\xB3\xB8\xCC\x62\xD0\xE9\x8D\x82\x82\x18\x09\x71\x05\x5B\x45\x7C\x06\xF3"
"\x51\xE6\x11\x64\xFC\x5A\x9D\xE9\xD8\x3D\x1D\x13\x78\x96\x40\x01\x38\x0B\x5B"
"\x99\xEE\x4C\x5C\x7D\x50\xAC\x24\x62\xA4\xB7\xEA\x34\xFD\x32\xD9\x0B\xD8\xD4"
"\xB4\x64\x10\x26\x36\x73\xF9\x00\xD1\xC6\x04\x70\x16\x5D\xF9\xF3\xCB\x48\x01"
"\x6A\xB8\xCA\x45\xCE\x68\x75\xA7\x1D\x97\x79\x15\xCA\x82\x51\xB5\x02\x58\x74"
"\x8D\xBC\x37\xFE\x33\x2E\xDC\x28\x55" }
};

static DWORD CRC32Table[256] = {
0x00000000,0x77073096,0xEE0E612C,0x990951BA,0x076DC419,0x706AF48F,0xE963A535,
0x9E6495A3,0x0EDB8832,0x79DCB8A4,0xE0D5E91E,0x97D2D988,0x09B64C2B,0x7EB17CBD,
0xE7B82D07,0x90BF1D91,0x1DB71064,0x6AB020F2,0xF3B97148,0x84BE41DE,0x1ADAD47D,
0x6DDDE4EB,0xF4D4B551,0x83D385C7,0x136C9856,0x646BA8C0,0xFD62F97A,0x8A65C9EC,
0x14015C4F,0x63066CD9,0xFA0F3D63,0x8D080DF5,0x3B6E20C8,0x4C69105E,0xD56041E4,
0xA2677172,0x3C03E4D1,0x4B04D447,0xD20D85FD,0xA50AB56B,0x35B5A8FA,0x42B2986C,
0xDBBBC9D6,0xACBCF940,0x32D86CE3,0x45DF5C75,0xDCD60DCF,0xABD13D59,0x26D930AC,
0x51DE003A,0xC8D75180,0xBFD06116,0x21B4F4B5,0x56B3C423,0xCFBA9599,0xB8BDA50F,
0x2802B89E,0x5F058808,0xC60CD9B2,0xB10BE924,0x2F6F7C87,0x58684C11,0xC1611DAB,
0xB6662D3D,0x76DC4190,0x01DB7106,0x98D220BC,0xEFD5102A,0x71B18589,0x06B6B51F,
0x9FBFE4A5,0xE8B8D433,0x7807C9A2,0x0F00F934,0x9609A88E,0xE10E9818,0x7F6A0DBB,
0x086D3D2D,0x91646C97,0xE6635C01,0x6B6B51F4,0x1C6C6162,0x856530D8,0xF262004E,
0x6C0695ED,0x1B01A57B,0x8208F4C1,0xF50FC457,0x65B0D9C6,0x12B7E950,0x8BBEB8EA,
0xFCB9887C,0x62DD1DDF,0x15DA2D49,0x8CD37CF3,0xFBD44C65,0x4DB26158,0x3AB551CE,
0xA3BC0074,0xD4BB30E2,0x4ADFA541,0x3DD895D7,0xA4D1C46D,0xD3D6F4FB,0x4369E96A,
0x346ED9FC,0xAD678846,0xDA60B8D0,0x44042D73,0x33031DE5,0xAA0A4C5F,0xDD0D7CC9,
0x5005713C,0x270241AA,0xBE0B1010,0xC90C2086,0x5768B525,0x206F85B3,0xB966D409,
0xCE61E49F,0x5EDEF90E,0x29D9C998,0xB0D09822,0xC7D7A8B4,0x59B33D17,0x2EB40D81,
0xB7BD5C3B,0xC0BA6CAD,0xEDB88320,0x9ABFB3B6,0x03B6E20C,0x74B1D29A,0xEAD54739,
0x9DD277AF,0x04DB2615,0x73DC1683,0xE3630B12,0x94643B84,0x0D6D6A3E,0x7A6A5AA8,
0xE40ECF0B,0x9309FF9D,0x0A00AE27,0x7D079EB1,0xF00F9344,0x8708A3D2,0x1E01F268,
0x6906C2FE,0xF762575D,0x806567CB,0x196C3671,0x6E6B06E7,0xFED41B76,0x89D32BE0,
0x10DA7A5A,0x67DD4ACC,0xF9B9DF6F,0x8EBEEFF9,0x17B7BE43,0x60B08ED5,0xD6D6A3E8,
0xA1D1937E,0x38D8C2C4,0x4FDFF252,0xD1BB67F1,0xA6BC5767,0x3FB506DD,0x48B2364B,
0xD80D2BDA,0xAF0A1B4C,0x36034AF6,0x41047A60,0xDF60EFC3,0xA867DF55,0x316E8EEF,
0x4669BE79,0xCB61B38C,0xBC66831A,0x256FD2A0,0x5268E236,0xCC0C7795,0xBB0B4703,
0x220216B9,0x5505262F,0xC5BA3BBE,0xB2BD0B28,0x2BB45A92,0x5CB36A04,0xC2D7FFA7,
0xB5D0CF31,0x2CD99E8B,0x5BDEAE1D,0x9B64C2B0,0xEC63F226,0x756AA39C,0x026D930A,
0x9C0906A9,0xEB0E363F,0x72076785,0x05005713,0x95BF4A82,0xE2B87A14,0x7BB12BAE,
0x0CB61B38,0x92D28E9B,0xE5D5BE0D,0x7CDCEFB7,0x0BDBDF21,0x86D3D2D4,0xF1D4E242,
0x68DDB3F8,0x1FDA836E,0x81BE16CD,0xF6B9265B,0x6FB077E1,0x18B74777,0x88085AE6,
0xFF0F6A70,0x66063BCA,0x11010B5C,0x8F659EFF,0xF862AE69,0x616BFFD3,0x166CCF45,
0xA00AE278,0xD70DD2EE,0x4E048354,0x3903B3C2,0xA7672661,0xD06016F7,0x4969474D,
0x3E6E77DB,0xAED16A4A,0xD9D65ADC,0x40DF0B66,0x37D83BF0,0xA9BCAE53,0xDEBB9EC5,
0x47B2CF7F,0x30B5FFE9,0xBDBDF21C,0xCABAC28A,0x53B39330,0x24B4A3A6,0xBAD03605,
0xCDD70693,0x54DE5729,0x23D967BF,0xB3667A2E,0xC4614AB8,0x5D681B02,0x2A6F2B94,
0xB40BBE37,0xC30C8EA1,0x5A05DF1B,0x2D02EF8D
};

void CRC32(DWORD *pdwCRC32, BYTE *pbBuffer, DWORD dwLength)
{
	DWORD i;

	for (i = 0; i < dwLength; i++)
		*pdwCRC32 = (*pdwCRC32 >> 8) ^ CRC32Table[(*pdwCRC32 ^ pbBuffer[i])
		& 0xff];
}

int main(int argc, char *argv[])
{
	HKEY hKey;
	BYTE szDirectory[MAX_PATH], szFile[MAX_PATH];
	BYTE *p1, *p2, *pbBuffer = NULL, pbHexByte[3], pbDigest[20],
		pbBlock[RIJNDAEL_BLOCKSIZE];
	static BYTE pbData[512];
	DWORD i, j, k, dwType, *pdwBlock, dwCRC32, dwError, dwFileSize, dwKeyId,
		dwSize = sizeof(pbData);
	DATA_BLOB DataIn, DataOut;
	SHA1_CTX SHA1Ctx;
	RIJNDAEL_context RijndaelCtx;
	verylong vlN = 0, vlM = 0, vlMprime = 0;
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind = INVALID_HANDLE_VALUE;
	HANDLE hFile = NULL, hMap = NULL;

	// Recover platform specific token
	if (RegOpenKey(HKEY_CURRENT_USER, "Software\\Skype\\ProtectedStorage",
		&hKey) != ERROR_SUCCESS) {
		printf("[-] RegOpenKey() failed\n");
		return -1;
	}
	if (RegQueryValueEx(hKey, "0", NULL, &dwType, pbData, &dwSize)
		!= ERROR_SUCCESS) {
		printf("[-] RegQueryValue() failed\n");
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);
	DataIn.cbData = dwSize;
	DataIn.pbData = pbData;
	if (CryptUnprotectData(&DataIn, NULL, NULL, NULL, NULL, 0, &DataOut)
		== FALSE) {
		printf("[-] CryptUnprotectData() failed\n");
		return -1;
	}
#ifdef DEBUG
	for (i = 0; i < DataOut.cbData; i++)
		printf("%02x", DataOut.pbData[i]);
	printf("\n");
#endif
	// Expand key material to 32 bytes thanks to SHA1
	dwSize = RIJNDAEL_MAX_KEYSIZE;
	memset(pbData, 0, sizeof(pbData));
	for (i = 0; TRUE; i++, dwSize -=20) {
		SHA1_Init(&SHA1Ctx);
		j = BYTESWAP(i);
		SHA1_Update(&SHA1Ctx, (unsigned char *)&j, 4);
		SHA1_Update(&SHA1Ctx, DataOut.pbData, DataOut.cbData);
		SHA1_Final(pbDigest, &SHA1Ctx);
		if (dwSize <= 20)
			break;
		memcpy(&pbData[i * 20], pbDigest, 20);
	}
	memcpy(&pbData[i * 20], pbDigest, dwSize);
#ifdef DEBUG
	for (j = 0; j < RIJNDAEL_MAX_KEYSIZE; j++)
		printf("%02x", pbData[j]);
	printf("\n");
#endif
	rijndael_setup(&RijndaelCtx, RIJNDAEL_MAX_KEYSIZE, pbData);
	LocalFree(DataOut.pbData);

	if (ExpandEnvironmentStrings("%USERPROFILE%\\Application Data\\Skype\\*",
		szDirectory, sizeof(szDirectory) - 2) == 0) {
		printf ("[-] ExpandEnvironmentStrings() failed (%d)\n", GetLastError());
		return -1;
	}
	if ((hFind = FindFirstFile(szDirectory, &FindFileData))
		== INVALID_HANDLE_VALUE) {
		printf ("[-] FindFirstFile() failed (%d)\n", GetLastError());
		return -1;
	} 
	do {
		if ((FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0)
			continue;
		if (strcmp(FindFileData.cFileName, ".") == 0
			|| strcmp(FindFileData.cFileName, "..") == 0)
			continue;
		printf ("[%s]\n", FindFileData.cFileName);
		strcpy(szFile, szDirectory);
		szFile[strlen(szFile) - 1] = '\0';
		strcat(szFile, FindFileData.cFileName);
		strcat(szFile, "\\config.xml");
		// printf("%s\n", szFile);
		hFile = CreateFile(szFile, GENERIC_READ, 0, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE) {
			printf("[-] CreateFile() failed (%d)\n", GetLastError());
			goto Cleanup;
		}
		dwFileSize = GetFileSize(hFile, NULL);
		hMap = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, dwFileSize,
			NULL);
		if (hMap == NULL) {
			printf("[-] CreateFileMapping() failed (%d)\n", GetLastError());
			goto Cleanup;
		}
		pbBuffer = MapViewOfFile(hMap, FILE_MAP_READ, 0, 0, dwFileSize);
		if (pbBuffer == NULL) {
			printf("[-] MapViewOfFile() failed (%d)\n", GetLastError());
			goto Cleanup;
		}
		if ((p1 = strstr(pbBuffer, "<Credentials>")) == NULL
			|| (p2 = strstr(p1, "</Credentials>")) == NULL
			|| (p2 - p1 - strlen("<Credentials>")) > sizeof(szCredentials))
			goto Cleanup;
		memset(szCredentials, 0, sizeof(szCredentials));
		strncpy(szCredentials, p1 + strlen("<Credentials>"), p2 - p1
			- strlen("<Credentials>"));
		memset(pbHexByte, 0, sizeof(pbHexByte));
		for (i = 0, j = 0; i < strlen(szCredentials); i += 2) {
			strncpy(pbHexByte, &szCredentials[i], 2);
			pbCredentials[j++] = (BYTE)(strtoul(pbHexByte, NULL, 16));
		}
		dwCredentialsSize = j;
#ifdef DEBUG
		printf("%d\n", dwCredentialsSize);
#endif
		// Decrypt the credentials
		pdwBlock = (DWORD *)pbBlock;
		dwCredentialsSize -= 2;
		dwCRC32 = 0xffffffff;
		CRC32(&dwCRC32, pbCredentials, dwCredentialsSize);
		dwCRC32 = (dwCRC32 ^ *(WORD *)(&pbCredentials[dwCredentialsSize]))
			& 0xffff;
#ifdef DEBUG
		printf("0x%08x\n", dwCRC32);
#endif
		// The CRC32 thing seems to be used with pdwBlock[2],
		// but it's always 0 ?
		for (j = 0, k = 0; j < dwCredentialsSize; j += RIJNDAEL_BLOCKSIZE,
			k++) {
			pdwBlock[0] = 0;
			pdwBlock[1] = 0;
			pdwBlock[2] = 0;
			pdwBlock[3] = BYTESWAP(k);
			rijndael_encrypt(&RijndaelCtx, pbBlock, pbBlock);
			dwSize = ((j + RIJNDAEL_BLOCKSIZE) < dwCredentialsSize) ?
				RIJNDAEL_BLOCKSIZE : dwCredentialsSize - j;
			for (i = 0; i < dwSize; i++)
				pbCredentials[i + j] ^= pbBlock[i];
#ifdef DEBUG
			for (i = 0; i < dwSize; i++)
				printf("%02x", pbCredentials[i + j]);
			printf("\n");
#endif
		}
		dwCRC32 = 0xffffffff;
		CRC32(&dwCRC32, pbCredentials, 16);
#ifdef DEBUG
		printf("0x%08x\n", dwCRC32);
#endif
		for (i = 16; i < dwCredentialsSize; i++) {
			dwCRC32 = 0x10dcd * dwCRC32 + 0x4271; // "FastTrack Cipher" ?
			pbCredentials[i] ^= (dwCRC32 >> 24) & 0xff;
		}
#ifdef DEBUG
		// Dumping almost-fully decrypted credentials
		for (i = 0; i < dwCredentialsSize; i++) {
			if (i != 0 && (i % 16) == 0)
				printf("\n");
			printf("%02x", pbCredentials[i]);
		}
		printf("\n");
#endif
		// Decrypt the RSA block
		dwKeyId = *(DWORD *)(&pbCredentials[16 + 128]);
		dwKeyId = BYTESWAP(dwKeyId);
		if (dwKeyId != 0 && dwKeyId != 1) {
			printf("[-] RSA key ID not implemented\n");
			goto Cleanup;
		}
		for (i = 0; i < mModulus[dwKeyId].dwSize; i++) {
			zlshift(vlN, 8, &vlN);
			zsadd(vlN, mModulus[dwKeyId].pbModulus[i], &vlN);
			zlshift(vlM, 8, &vlM);
			zsadd(vlM, pbCredentials[16 + 128 + 4 + i], &vlM);
		}
		zsexpmod(vlM, 0x10001, vlN, &vlMprime);
#ifdef DEBUG
		// zhwriteln(vlM);
		// zhwriteln(vlN);
		zhwriteln(vlMprime);
#endif
		memset(pbRSABlock, 0, sizeof(pbRSABlock));
		for (i = 0; i < mModulus[dwKeyId].dwSize; i++) {
			pbRSABlock[mModulus[dwKeyId].dwSize - i - 1] =
				zslowbits(vlMprime, 8);
			zrshift(vlMprime, 8, &vlMprime);
		}
		printf("[+] MD5 sum of \"login\\nskyper\\npassword\":\n");
		for (i = 0; i < 16; i++)
			printf("%02x", pbCredentials[i]);
		printf("\n");
		printf("[+] RSA private key (D):\n0x");
		for (i = 16; i < 16 + 128; i++)
			printf("%02x", pbCredentials[i]);
		printf("\n");
		if (pbRSABlock[mModulus[dwKeyId].dwSize - 1] != 0xBC)
			printf("[-] RSA decryption failed\n");
		else {
			p1 = NULL;
			for (i = 0; i < (mModulus[dwKeyId].dwSize - sizeof(DWORD) - 128);
				i++)
				if (*(DWORD *)(&pbRSABlock[i]) == 0x01800104) {
						p1 = &pbRSABlock[i + sizeof(DWORD)];
						break;
					}
			if (p1 != NULL) {
				printf("[+] RSA public key (N):\n0x");
				for (i = 0; i < 128; i++)
					printf("%02x", p1[i]);
				printf("\n");
			}
		}
Cleanup:
		// Memory cleanup
		if (pbBuffer != NULL)
			UnmapViewOfFile(pbBuffer), pbBuffer = NULL;
		if (hMap != NULL)
			CloseHandle(hMap), hMap = NULL;
		if (hFile != NULL)
			CloseHandle(hFile), hFile = NULL;
		if (vlMprime != 0)
			zfree(&vlMprime), vlMprime = 0;
		if (vlM != 0)
			zfree(&vlM), vlM = 0;
		if (vlN != 0)
			zfree(&vlN), vlN = 0;
	} while (FindNextFile(hFind, &FindFileData) != 0);
	dwError = GetLastError();
	FindClose(hFind);
	if (dwError != ERROR_NO_MORE_FILES) {
		printf ("[-] FindNextFile() failed (%d)\n", dwError);
		return -1;
	}

	return 0;
}
