#include <stdio.h>

unsigned char xor_table[31] =
{
  0x11,0x64,0x63,0x0b,0x03,0x38,0x57,0x56,0x2c,0x58,0x77,0x65,0x11,0x45,0x39,0x41,
  0x6f,0x4d,0x50,0x11,0x01,0x3b,0x63,0x7a,0x28,0x49,0x76,0x34,0x47,0x60,0x3f
};

int main(int argc, char *argv[])
{
  int i, j, k, l;
  char *p, buffer[1024];
  FILE *encrypted_file, *decrypted_file;
  char decrypt_mode = 0;

  if ((encrypted_file = fopen(argv[1], "rt")) == NULL)
    return -1;
  if ((decrypted_file = fopen("trace.dump", "wt")) == NULL)
  {
    fclose(encrypted_file);
    return -1;
  }
  k = 0; // global index in xor_table
  memset(buffer, 0, sizeof(buffer));
  while (fgets(buffer, sizeof(buffer) - 1, encrypted_file) != NULL)
  {
    if ((p = strchr(buffer, '\r')) != NULL)
      *p = '\0';
    if ((p = strchr(buffer, '\n')) != NULL)
      *p = '\0';
    l = strlen(buffer);      
    if (decrypt_mode == 1)
    {
      for (i = 0, j = 0; i < l; i++, j++, k = (k + 1) % 31)
      {
        if (buffer[i] == 1)
        {
          buffer[j] = (0x7f - buffer[i + 1]) ^ xor_table[k]; 
          i++;
        }
        else if (buffer[i] == 2)
        {
          buffer[j] = buffer[i + 1];
          i++;
        }
        else
          buffer[j] = buffer[i] ^ xor_table[k];
      }
      buffer[j] = '\0';
    }
    else if (decrypt_mode == 0 && l == 0)
      decrypt_mode = 1;
    fprintf(decrypted_file, "%s\n", buffer);
  }
  fclose(encrypted_file);
  fclose(decrypted_file);

  return 0;
}
